/* - AdvServoCurrentListener -
 * Current change event handling code
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.CurrentChangeListener;
import com.phidgets.event.CurrentChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;

public class AdvServoCurrentListener implements CurrentChangeListener{
    
    private JComboBox servoCmb;
    private JTextField currentTxt;
    
    /** Creates a new instance of AdvServoCurrentListener */
    public AdvServoCurrentListener(JComboBox servoCmb, JTextField currentTxt)
    {
        this.servoCmb = servoCmb;
        this.currentTxt = currentTxt;
    }

    public void currentChanged(CurrentChangeEvent currentChangeEvent)
    {
        if(currentChangeEvent.getIndex() == ((Integer)servoCmb.getSelectedItem()).intValue())
        {
            currentTxt.setText(Double.toString(currentChangeEvent.getValue()));
        }
    }
    
}
